//$Id: CParameter.cpp,v 1.5 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CParameter.hpp"
using Exponent::MathTools::CParameter;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CParameter, CCountedObject);

//	===========================================================================
CParameter::CParameter() : m_out(0), m_min(0), m_max(0), m_difference(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CParameter);
	this->setRange(0.0, 1.0);
	this->setValue(0.5);
}

//	===========================================================================
CParameter::CParameter(const double min, const double max, const double value) : m_out(0), m_min(0), m_max(0), m_difference(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CParameter);
	this->setRange(min, max);
	this->setValue(value);
}

//	===========================================================================
CParameter::~CParameter()
{
	EXPONENT_CLASS_DESTRUCTION(CParameter);
}

//	===========================================================================
void CParameter::setRange(const double min, const double max)
{
	if (min <= max)
	{
		m_min = min;
		m_max = max;
		m_difference = m_max - m_min;
	}
}

//	===========================================================================
void CParameter::setValue(const double value)
{
	m_out = (value * m_difference) + m_min;
}

//	===========================================================================
double CParameter::getValue() const
{
	return m_out;
}

//	===========================================================================
void CParameter::getValue(CString &text) const
{
	CDouble value(m_out);
	text = value.getValueAsString(2);
}

//	===========================================================================
double CParameter::setAndGetValue(const double value)
{
	this->setValue(value);
	return this->getValue();
}	

//	===========================================================================
long CParameter::doubleToLong(const long min, const long max, const double value)
{
	return (long)ceil(min + (value * (double)(max - min)));;
	//return (long)(min + (value * ((long)(0.99999 + max - min))));
}

//	===========================================================================
double CParameter::longToDouble(const long min, const long max, const long index)
{
	return (double)((index - min) * (0.99999 / (max - min)));
}

//	===========================================================================
double CParameter::doubleToDouble(const double min, const double max, const double value)
{
	return (value * (max - min)) + min;
}